
# Folders -----------------------------------------------------------------

raw.data.folder <- "./Data/"
plots.folder <- "./Plots/SessionNormalized_v2/"
output.folder <- "./Output/SessionNormalized_v2/"

# Files names --------------------------------------------------------
log.name = "logz_session_zscore.txt"
threshold = "INFO"
cleaned.raw.data <- "Cleaned_Unit_traces.rds"


Perievent.data <- "Perievents_filtered.rds"
Idx.data.name <- "Idx_of_events_session.rds"
Units.thresholded <- "Units_by_direction_session_zscoreSession.rds"

Unit.nr.name <- "units_per_cluster_session.csv"
Data.cluster.name <- "Cleaned_Unit_traces_clustered_baseline.csv"

# Generic  --------------------------------------------------------
bin.size <- 0.25 

# 1. Clean raw --------------------------------------------------------

normalize.spikes.per.session <- TRUE #FALSE # mutually exclusive with per event
normalize.spikes.method <- "zscore" # options are zscore or poisson.zscore

min.spikes <- 20 # 20
smooth.spikes <- TRUE
smooth.window <- 6
multiplier <- 1 # if 1 then no change. Use 4 if bin.size is 0.25 and want to transform to Hz.

remove.units <- c("SN_A1C1_traces_Baseline_1_SPK11a" , "SN_A1C1_traces_Baseline_1_SPK13a", 
                   "SN_A1C1_traces_Baseline_3_SPK06a", "SN_A2C1_traces_Baseline_1_SPK15b",
                   "SN_A2C1_traces_Baseline_3_SPK01a", "SN_A2C1_traces_Baseline_3_SPK02b", 
                   "SN_A2C1_traces_Baseline_3_SPK15a", "SN_A2C1_traces_BI_cmp_1_SPK01a", 
                   "SN_A2C1_traces_BI_cmp_1_SPK01b", "SN_A2C1_traces_BI_cmp_1_SPK08b", 
                   "SN_A2C1_traces_BI_cmp_1_SPK15a", "SN_A1C1_traces_CNO_1_SPK11a", 
                   "SN_A2C1_traces_CNO_1_SPK08a", "SN_A2C1_traces_CNO_2_SPK01a",
                   "SN_A2C1_traces_CNO_2_SPK11a", "SN_A2C1_traces_CNO_2_SPK15a", 
                   "SN_A1C1_traces_Saline_SPK11a", "SN_A2C1_traces_Saline_SPK01a", 
                   "SN_A2C1_traces_Saline_SPK08a", "SN_A2C1_traces_Saline_SPK11a", 
                   "SN_A2C1_traces_Saline_SPK15b", "SN_A2C1_traces_Vehicle_1_SPK02a", 
                   "SN_A2C1_traces_Vehicle_1_SPK08a", "SN_A2C1_traces_Vehicle_1_SPK09a",
                   "STN_A0C0_traces_Baseline_2_SPK06a","STN_A0C0_traces_Baseline_2_SPK08a",
                   "STN_A1C1_traces_Baseline_1_SPK02a","STN_A1C1_traces_Baseline_1_SPK07a", 
                   "STN_A1C1_traces_Baseline_2_SPK07a", "STN_A1C1_traces_Baseline_2_SPK09b", 
                   "STN_A1C1_traces_Baseline_3_SPK05a", "STN_A1C1_traces_Baseline_3_SPK06a", 
                   "STN_A1C1_traces_Baseline_3_SPK03b", "STN_A1C1_traces_Baseline_3_SPK13a", 
                   "STN_A1C1_traces_Baseline_4_SPK03a", "STN_A1C1_traces_Baseline_4_SPK12a", 
                   "STN_A1C1_traces_Baseline_4_SPK13a", "STN_A1C2_traces_Baseline_1_SPK09a", 
                   "STN_A1C2_traces_Baseline_2_SPK14a", "STN_A1C2_traces_Baseline_3_SPK02a",
                   "STN_A1C2_traces_Baseline_4_SPK14b", "STN_A1C1_traces_BI_cmp_1_SPK08c", 
                   "STN_A1C1_traces_BI_cmp_2_SPK03a","STN_A1C1_traces_BI_cmp_2_SPK05a", 
                   "STN_A1C1_traces_BI_cmp_2_SPK07a", "STN_A1C2_traces_BI_cmp_1_SPK07a", 
                   "STN_A1C2_traces_BI_cmp_1_SPK16a", "STN_A1C2_traces_BI_cmp_2_SPK13a", 
                   "STN_A0C0_traces_Vehicle_1_SPK12f", "STN_A1C1_traces_Vehicle_1_SPK05a", 
                   "STN_A1C1_traces_Vehicle_1_SPK06a", "STN_A1C1_traces_Vehicle_1_SPK14a", 
                   "STN_A1C1_traces_Vehicle_1_SPK15b", "STN_A1C1_traces_Vehicle_2_SPK13a", 
                   "STN_A1C2_traces_Vehicle_1_SPK02a", "STN_A1C2_traces_Vehicle_1_SPK07a")

# 2. Filter events  --------------------------------------------------------

# time range before and after event onset
before <- -7
after <- 15

normalize.spikes.per.event <- FALSE #TRUE
min.time.normalization <- -2
max.time.normalization <- -1

z.threshold <- 1.645 #1.645
threshold.min.time <- 0
threshold.max.time <- 1

one.sample.t.threshold <- TRUE # used to threshold units with t.test againt mean of baseline firing
one.sample.to.zero <- FALSE # run t.test comparing to 0

group.columns <- c("Area.brain", "TreatmentID", 
                   "FileID", "File.name", 
                   "SessionID")

unit.column <- c("Unit", "z.score", "Time.start")

perievent.columns <- c("Correct_Go_Sound_onset", "Go_Sound_onset", 
                       "Correct_Go_Pokes", 
                       "Correct_NG_Sound_onset", "FalseAlarm_Sound_onset", "NoGo_Sound_onset", 
                       "FalseAlarm_Pokes",
                       "NoGo_Trial_onset",  "FalseAlarm_Trial_onset", "Correct_NG_Trial_onset",
                       "Go_Trial_onset", "Correct_Go_Trial_onset",
                       "Precue_Pokes", "ITI_Pokes", "Light_onset_corrected",
                       "Reward_onset", "Correct_NG_Reward_onset", "Correct_Go_Reward_onset",
                       "Freezing_80_start", "Freezing_80_stop")

protocol.columns <- c("TrialCnt",
                      "Period")

# 4. Permute events  --------------------------------------------------------
permute <- FALSE

# 5. Cluster permutations  --------------------------------------------------------
one.sample.select_columns <- c("UnitID", "norm.time", "z.score")
one.sample.group_columns <- c("Area.brain", "TreatmentID", "Event")

iterations <- 1:5000
one.sample.observed.file <- "One.sample_observed.rds"
one.sample.permuted.file <- "One.sample_permuted.rds"

two.sample.observed.file <- "Two.sample_observed.rds"
two.sample.permuted.file <- "Two.sample_permuted.rds"



